#ifndef _VGA_LED_H
#define _VGA_LED_H

#include <linux/ioctl.h>

#define NUM_COORDS 12
#define NUM_PIXELS 108

/*

Gautham Vunnam
Columbia University

*/


/* used to specify the location of the center of the ball */
typedef struct {
	int coor; // specifies x(0) or y(1)
	unsigned int  val;  // coordinate of ball center
} vga_led_arg_t;

// 120 faces with corresponding vertice indexes 
int faces[120][3] = {
	{0, 1, 2}, 
	{0, 3, 1}, 
	{0, 4, 3}, 
	{0, 5, 4}, 
	{0, 6, 5}, 
	{0, 7, 6}, 
	{0, 8, 7}, 
	{0, 9, 8}, 
	{0, 10, 9}, 
	{0, 11, 10}, 
	{0, 12, 11}, 
	{0, 13, 12}, 
	{0, 14, 13}, 
	{0, 15, 14}, 
	{0, 16, 15}, 
	{0, 17, 16}, 
	{0, 18, 17}, 
	{0, 19, 18}, 
	{0, 20, 19}, 
	{0, 2, 20}, 
	{21, 22, 23}, 
	{21, 23, 24}, 
	{21, 24, 25}, 
	{21, 25, 26}, 
	{21, 26, 27}, 
	{21, 27, 28}, 
	{21, 28, 29}, 
	{21, 29, 30}, 
	{21, 30, 31}, 
	{21, 31, 32}, 
	{21, 32, 33}, 
	{21, 33, 34}, 
	{21, 34, 35}, 
	{21, 35, 36}, 
	{21, 36, 37}, 
	{21, 37, 38}, 
	{21, 38, 39}, 
	{21, 39, 40}, 
	{21, 40, 41}, 
	{21, 41, 22}, 
	{18, 19, 42}, 
	{8, 43, 44}, 
	{17, 18, 45}, 
	{1, 46, 47}, 
	{7, 44, 48}, 
	{6, 48, 49}, 
	{17, 50, 51}, 
	{5, 49, 52}, 
	{15, 16, 51}, 
	{4, 52, 53}, 
	{14, 15, 54}, 
	{3, 53, 46}, 
	{14, 55, 56}, 
	{13, 56, 57}, 
	{12, 57, 58}, 
	{11, 58, 59}, 
	{2, 47, 60}, 
	{10, 59, 61}, 
	{20, 60, 42}, 
	{8, 9, 61}, 
	{22, 47, 46}, 
	{24, 23, 46}, 
	{24, 53, 52}, 
	{25, 52, 49}, 
	{27, 26, 49}, 
	{28, 27, 48}, 
	{28, 44, 43}, 
	{29, 43, 61}, 
	{30, 61, 59}, 
	{31, 59, 58}, 
	{32, 58, 57}, 
	{33, 57, 56}, 
	{34, 56, 55}, 
	{35, 55, 54}, 
	{37, 36, 54}, 
	{37, 51, 50}, 
	{39, 38, 50}, 
	{40, 39, 45}, 
	{40, 42, 60}, 
	{41, 60, 47}, 
	{45, 18, 42}, 
	{7, 8, 44}, 
	{50, 17, 45}, 
	{2, 1, 47}, 
	{6, 7, 48}, 
	{5, 6, 49}, 
	{16, 17, 51}, 
	{4, 5, 52}, 
	{54, 15, 51}, 
	{3, 4, 53}, 
	{55, 14, 54}, 
	{1, 3, 46}, 
	{13, 14, 56}, 
	{12, 13, 57}, 
	{11, 12, 58}, 
	{10, 11, 59}, 
	{20, 2, 60}, 
	{9, 10, 61}, 
	{19, 20, 42}, 
	{43, 8, 61}, 
	{23, 22, 46}, 
	{53, 24, 46}, 
	{25, 24, 52}, 
	{26, 25, 49}, 
	{48, 27, 49}, 
	{44, 28, 48}, 
	{29, 28, 43}, 
	{30, 29, 61}, 
	{31, 30, 59}, 
	{32, 31, 58}, 
	{33, 32, 57}, 
	{34, 33, 56}, 
	{35, 34, 55}, 
	{36, 35, 54}, 
	{51, 37, 54}, 
	{38, 37, 50}, 
	{45, 39, 50}, 
	{42, 40, 45}, 
	{41, 40, 60}, 
	{22, 41, 47} 
};

// Vertices for all 120 faces of the plate 
float vertices[62][4] = {
	{0., 0., 0., 1.}, 
	{-0.309, 0., 0.9511, 1.}, 
	{0., 0., 1., 1.}, 
	{-0.5878, 0., 0.809, 1.}, 
	{-0.809, 0., 0.5878, 1.}, 
	{-0.9511, 0., 0.309, 1.}, 
	{-1., 0., -0., 1.}, 
	{-0.9511, 0., -0.309, 1.}, 
	{-0.809, 0., -0.5878, 1.}, 
	{-0.5878, 0., -0.809, 1.}, 
	{-0.309, 0., -0.9511, 1.}, 
	{0., 0., -1., 1.}, 
	{0.309, 0., -0.9511, 1.}, 
	{0.5878, 0., -0.809, 1.}, 
	{0.809, 0., -0.5878, 1.}, 
	{0.9511, 0., -0.309, 1.}, 
	{1., 0., 0., 1.}, 
	{0.9511, 0., 0.309, 1.}, 
	{0.809, 0., 0.5878, 1.}, 
	{0.5878, 0., 0.809, 1.}, 
	{0.309, 0., 0.9511, 1.}, 
	{-0., 0.1903, 0., 1.}, 
	{-0., 0.1903, 0.4789, 1.}, 
	{-0.148, 0.1903, 0.4554, 1.}, 
	{-0.2815, 0.1903, 0.3874, 1.}, 
	{-0.3874, 0.1903, 0.2815, 1.}, 
	{-0.4554, 0.1903, 0.148, 1.}, 
	{-0.4789, 0.1903, 0., 1.}, 
	{-0.4554, 0.1903, -0.148, 1.}, 
	{-0.3874, 0.1903, -0.2815, 1.}, 
	{-0.2815, 0.1903, -0.3874, 1.}, 
	{-0.148, 0.1903, -0.4554, 1.}, 
	{0., 0.1903, -0.4789, 1.}, 
	{0.148, 0.1903, -0.4554, 1.}, 
	{0.2815, 0.1903, -0.3874, 1.}, 
	{0.3874, 0.1903, -0.2815, 1.}, 
	{0.4554, 0.1903, -0.148, 1.}, 
	{0.4789, 0.1903, 0., 1.}, 
	{0.4554, 0.1903, 0.148, 1.}, 
	{0.3874, 0.1903, 0.2815, 1.}, 
	{0.2815, 0.1903, 0.3874, 1.}, 
	{0.148, 0.1903, 0.4554, 1.}, 
	{0.4743, 0.1903, 0.6528, 1.}, 
	{-0.6528, 0.1903, -0.4743, 1.}, 
	{-0.7674, 0.1903, -0.2493, 1.}, 
	{0.6528, 0.1903, 0.4743, 1.}, 
	{-0.2493, 0.1903, 0.7674, 1.}, 
	{-0., 0.1903, 0.8068, 1.}, 
	{-0.8068, 0.1903, 0., 1.}, 
	{-0.7674, 0.1903, 0.2493, 1.}, 
	{0.7674, 0.1903, 0.2493, 1.}, 
	{0.8068, 0.1903, 0., 1.}, 
	{-0.6528, 0.1903, 0.4743, 1.}, 
	{-0.4743, 0.1903, 0.6528, 1.}, 
	{0.7674, 0.1903, -0.2493, 1.}, 
	{0.6528, 0.1903, -0.4743, 1.}, 
	{0.4743, 0.1903, -0.6528, 1.}, 
	{0.2493, 0.1903, -0.7674, 1.}, 
	{0., 0.1903, -0.8068, 1.}, 
	{-0.2493, 0.1903, -0.7674, 1.}, 
	{0.2493, 0.1903, 0.7674, 1.}, 
	{-0.4743, 0.1903, -0.6528, 1.}
};

// Default world view matrix
float VIEW[4][4] = {
	{1, 0, 0, 0}, 
	{0, 1, 0, 0}, 
	{0, 0, 1, -5}, 
	{0, 0, 0, 1}
};

// Default world projection matrix
float PROJECTION[4][4] = {
	{2.4178, 0,      0, 0}, 
	{0,      2.4178, 0, 0}, 
	{0,      0,     -2, -3}, 
	{0,      0,     -1, 0}
};

float TRANSLATE[4][4] = {
	{1, 0, 0, 0},
	{0, 1, 0, 0},
	{0, 0, 1, 0},
	{0, 0, 0, 1}
};

float SCALE[4][4] = {
	{1, 0, 0, 0},
	{0, 1, 0, 0},
	{0, 0, 1, 0},
	{0, 0, 0, 1}
};


/* ioctls and their arguments */
#define VGA_LED_WRITE_DIGIT _IOW('q', 1, vga_led_arg_t *)
#define VGA_LED_READ_DIGIT  _IOR('q', 2, vga_led_arg_t *)

#endif
